package com.googlecode.jpattern.core;

import java.io.Serializable;

import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.service.log.ILoggerService;
import com.googlecode.jpattern.service.mail.IMailService;
import com.googlecode.jpattern.service.transaction.ITransactionService;

/**
 * 
 * @author Francesco Cina'
 *
 * 07/apr/2010
 */
public interface IProvider extends Serializable {
	
    void accept(ICommand aCommand);

    IService getService(String serviceName);
    
    ILoggerService getLoggerService();
    
    IMailService getMailService();
    
    ITransactionService getTransactionService();
    
    boolean contains(String aServiceName);
}
