package com.googlecode.jpattern.core.command;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;


/**
 * 
 * @author Francesco Cina'
 *
 * 27/feb/2011
 */
public class CommandResult extends ICommandResult {

	private static final long serialVersionUID = 1L;
	private List<ICommand> commandInExecutionList = new Vector<ICommand>();

    private List<IErrorMessage> errorMessages;

    public CommandResult() {
        errorMessages = new Vector<IErrorMessage>();
    }
	
    @Override
	public final synchronized boolean isExecutionEnd() {
		return commandInExecutionList.size()==0;
	}

    @Override
	public final synchronized void waitExecutionEnd() throws InterruptedException {
		if (!isExecutionEnd()) {
			wait();
		}
	}
	
    @Override
	protected final synchronized void commandStartExecution(ICommand aCommand) {
		commandInExecutionList.add(aCommand);
	}
	
    @Override
	protected final synchronized void commandEndExecution(ICommand aCommand) {
		commandInExecutionList.remove(aCommand);
		if (isExecutionEnd()) {
			notifyAll();
		}
	}
	

	@Override
	protected final synchronized void removeAllCommands() {
		commandInExecutionList.clear();
		if (isExecutionEnd()) {
			notifyAll();
		}		
	}

	
	@Override
    public final synchronized List<IErrorMessage> getErrorMessages() {
    	if ( errorMessages == null ) {
    		errorMessages = new Vector<IErrorMessage>();
    	}
        return errorMessages;
    }

    @Override
	public final synchronized void addErrorMessage(IErrorMessage errorMessage) {
		getErrorMessages().add(errorMessage);		
	}
    
    @Override
    public synchronized boolean isValid() {
        return getErrorMessages().size() == 0;
    }

    @Override
    public synchronized String asString() {

        StringBuffer buffer = new StringBuffer();
        buffer.append("[ \n");
        buffer.append("{ isValid = " + isValid() + " } \n");
      //  buffer.append("{ returnObject = " + returnedObject() + " } \n");
        buffer.append("{ errormessages = \n");
        for (Iterator<IErrorMessage> iter = errorMessages.iterator(); iter.hasNext();) {
            IErrorMessage msg = iter.next();
            buffer.append("( " + msg.getName() + " : " + msg.getMessage());
            int len = msg.getParameters().length;
            for (int i = 0; i < len; i++) {
                buffer.append(" " + msg.getParameters()[i] + "  ");
            }
            buffer.append(" )");
        }
        buffer.append(" }\n");
        buffer.append(" ] ");

        return buffer.toString();

    }
}
