package com.googlecode.jpattern.core.command;


/**
 * 
 * @author Francesco Cina'
 *
 * 27/feb/2011
 * 
 * This implementation of ICommandExecutor is a very simple
 * executor which launches the execution in a Synchronous way.
 * The next ICommand in the chain is executed only if the result
 * of the previous id valid.
 */
public class ConditionalCommandExecutor implements ICommandExecutor {

	private static final long serialVersionUID = 1L;

	@Override
	public void addCommandToPool(ACommand aCommand) {
		aCommand.run();
	}
	
	@Override
	public boolean executeNext(ICommandResult result) {
		return result.isValid();
	}

	@Override
	public IChainStrategy getChainStrategy() {
		return new ManagedChainStrategy();
	}

}
