package com.googlecode.jpattern.core.command;


/**
 * 
 * @author Francesco Cina'
 *
 * 27/feb/2011
 */
public abstract class ICommandResult implements IResult {
	
	private static final long serialVersionUID = 1L;

	public abstract boolean isExecutionEnd();
	
	public abstract void waitExecutionEnd() throws InterruptedException;
	
	public abstract void addErrorMessage(IErrorMessage errorMessage);
    
	public abstract String asString();
	
	protected abstract void commandStartExecution(ICommand aCommand);
	
	protected abstract void commandEndExecution(ICommand aCommand);

	protected abstract void removeAllCommands();
	
}
