package com.googlecode.jpattern.core.command;


/**
 * 
 * @author Francesco Cina'
 *
 * 27/feb/2011
 * 
 * This implementation of IAsyncCommandPool is a pool which simply
 * starts every new command in a new Thread.
 * No controls exist on the total number of Threads running.
 */
public class SimpleAsyncCommandExecutor implements ICommandExecutor {

	private static final long serialVersionUID = 1L;

	@Override
	public void addCommandToPool(ACommand asyncCommand) {
		new Thread(asyncCommand).start();
	}

	@Override
	public boolean executeNext(ICommandResult result) {
		return true;
	}

	@Override
	public IChainStrategy getChainStrategy() {
		return new UnmanagedChainStrategy();
	}
	
}
