package com.googlecode.jpattern.core.command.facade;

import java.util.List;

import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.IErrorMessage;

/**
 * 
 * @author Francesco Cina'
 *
 * 25 Feb 2011
 */
public class CommandFacadeResult<E> implements ICommandFacadeResult<E>  {


    private static final long serialVersionUID = 1L;
    private ICommandResult result;
    private E returnedObject;
    
    public CommandFacadeResult(ICommandResult aResult, E returnedObject) {
            result = aResult;
            this.returnedObject = returnedObject;
    }

    @Override
    public String asString() {
        return result.asString();
    }

    @Override
    public List<IErrorMessage> getErrorMessages() {
        return result.getErrorMessages();
    }

    @Override
    public boolean isValid() {
        return result.isValid();
    }

    @Override
    public E getReturnedObject() {
        return returnedObject;
    }

}
