package com.googlecode.jpattern.core.textfiles;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ErrorMessage;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.service.log.ILogger;

/**
 * 
 * @author Francesco Cina'
 *
 * 10/giu/2010
 */
public class FileDeleteCommand extends ACommand {

	private ILogger logger;
	private static final long serialVersionUID = 1L;
	private StringBuffer fileName;
	private IResource resource;
	
	public FileDeleteCommand(IResource resource, StringBuffer fileName ) {
		this( resource, fileName, new NullCommand() );
	}
	
	public FileDeleteCommand(IResource resource, StringBuffer fileName, ICommand aSuccessor) {
		super(aSuccessor);
		this.resource = resource;
		this.fileName = fileName;
	}
	
	@Override
	protected void internalRollBack(ICommandResult result) {
	}

	@Override
	protected void result(ICommandResult result) {
		logger = getProvider().getLoggerService().logger(FileDeleteCommand.class);
		logger.info("result", "deleting file " + fileName.toString() + " from " + resource.getPath());
		
		if ( !resource.getFilenames().contains(fileName.toString()) ) {
			String error = "impossible to delete file " + fileName.toString() + ": file doesn't exit";
			logger.error("result", error);
			result.addErrorMessage( new ErrorMessage("FileDeleteCommand", error) );
			return;
		}
		
		if ( resource.delete(fileName.toString()) ) {
			logger.debug("result", "file deleted");
		}
		else {
			String errorText = "error deleting file " + fileName.toString();
			logger.error("result", errorText);
			result.addErrorMessage( new ErrorMessage("FileDeleteCommand", errorText) );
		}
		
	}

}
