package com.googlecode.jpattern.core.textfiles;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ErrorMessage;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.service.log.ILogger;

/**
 * 
 * @author Francesco Cina'
 *
 * 10/giu/2010
 */
public class FileRenameCommand extends ACommand {

	private static final long serialVersionUID = 1L;
	private ILogger logger;
	private StringBuffer oldFileName;
	private StringBuffer newFileName;
	private IResource resource;
	
	public FileRenameCommand(StringBuffer oldFileName, StringBuffer newFileName, IResource resource) {
		this( oldFileName, newFileName, resource, new NullCommand() );
	}
	
	public FileRenameCommand(StringBuffer oldFileName, StringBuffer newFileName, IResource resource, ICommand aSuccessor) {
		super(aSuccessor);
		this.oldFileName = oldFileName;
		this.newFileName = newFileName;
		this.resource = resource;
	}
	
	@Override
	protected void internalRollBack(ICommandResult result) {
	}

	@Override
	protected void result(ICommandResult result) {
		logger = getProvider().getLoggerService().logger(FileRenameCommand.class);
		logger.info("result", "rename file from " + oldFileName.toString() + " to " + newFileName.toString());
		
		if ( !resource.getFilenames().contains(oldFileName.toString()) ) {
			logger.error("result", "impossible to rename file: source file doesn't exist");
			result.addErrorMessage( new ErrorMessage("FileRenameCommand", "impossible to rename file: source file doesn't exists") );
			return;
		}
		
		if ( resource.getFilenames().contains(newFileName.toString()) ) {
			logger.error("result", "impossible to rename file: destination file exist");
			result.addErrorMessage( new ErrorMessage("FileRenameCommand", "impossible to rename file: destination file exists") );
			return;
		}
		
		if ( !resource.rename(oldFileName.toString(), newFileName.toString()) ){
			logger.error("result", "impossible to rename file " + oldFileName.toString());
			result.addErrorMessage( new ErrorMessage("FileRenameCommand", "impossible to rename file " + oldFileName.toString()) );
		}
	
	}

}
