package com.googlecode.jpattern.core.util;

import java.math.BigDecimal;

/**
 * 
 * @author Francesco Cina'
 *
 * 20/lug/2010
 */
public abstract class StringHelper {

	
	/**
	 * Restituisce la stringa tagliata alla lunghezza length richiesta. Se la stringa e' di lunghezza minore di length viene
	 * restituita la stringa inalterata. 
	 * @param text la striga da tagliare
	 * @param length la lunghezza massima della stringa
	 * @return
	 */
	public static String cut(String text, int length) {
		if ( (length>=0) && text.length()>length) {
			return text.substring(0, length);
		}
		return text;
	}
	
	/**
	 * Effettua il parsing di una String in un tipo BigDecimal. L'utilizzo del BigDecimal evita i
	 * tipici errori di arrotondamento dovuti all'utilizzo del tipo double.
	 * Il separatore decimale della stringa in ingresso puo' essere indipendentemente "." oppure "," 
	 * @param value la stringa da analizzare
	 * @param decimalPositions le posizioni decimali desiderate
	 * @return la stringa convertita in BigDecimal
	 */
	public static BigDecimal toBigDecimal(String value, int decimalPositions) throws Exception {
		// il separatore deve essere il '.', sostituisco una eventuale ','
		BigDecimal numero = new BigDecimal(value.replace(',', '.') );
		numero = numero.setScale(decimalPositions, BigDecimal.ROUND_HALF_UP);
		return numero;
	}
	
	/**
	 * Effettua il parsing di una String in un tipo BigDecimal. L'utilizzo del BigDecimal evita i
	 * tipici errori di arrotondamento dovuti all'utilizzo del tipo double.
	 * Il separatore decimale della stringa in ingresso puo' essere indipendentemente "." oppure ",".
	 * Se il parsing non riesce viene restituito il defaultValue;
	 * @param value la stringa da analizzare
	 * @param decimalPositions le posizioni decimali desiderate
	 * @return la stringa convertita in BigDecimal o il defaultValue
	 */
	public static BigDecimal toBigDecimal(String value, int decimalPositions, BigDecimal defaultValue) {
		try {
			return toBigDecimal(value, decimalPositions);
		} catch (Exception e) {
			return defaultValue;
		}
	}
	

	/**
	 * Restituisce un array di tutte le sottostringhe risultanti dallo split di una stringa source
	 * in base al pattern passato
	 * @param source La stringa da splittare
	 * @param pattern il pattern regex in base al quale splittare la stringa source
	 * @return
	 */
	public static String[] tokenize(String source, String pattern) {
		return source.split(pattern);
	}
	
}
