package com.googlecode.jpattern.core.util;

/**
 * 
 * @author Francesco Cina' 09/nov/2010 - 08.51.03
 *
 */
public abstract class ValueUtil {

	public static String stringNotNull(String value, String defaultValue) {
		return objectNotNull(String.class, value, defaultValue);
	}
	
	public static String stringNotNullTrimmed(String value, String defaultValue) {
		String result = stringNotNull(value, defaultValue);
		if ( result != null) {
			result = result.trim();
		}
		return result;
	}

	public static <E> E objectNotNull( E value, E defaultValue) {
		if (value == null) {
			return defaultValue;
		}
		return value;
	}
	
	public static <E> E objectNotNull(Class<E> aClass, E value, E defaultValue) {
		if (value == null) {
			return defaultValue;
		}
		return value;
	}

	@SuppressWarnings("unchecked")
	public static <E> E castObjectNotNull(Class<E> aClass, Object objectToCast, E defaultValue) {
		if (objectToCast == null || !aClass.isInstance(objectToCast)) {
			return defaultValue;
		}
		return (E) objectToCast;
	}
}
