package com.googlecode.jpattern.core.xml;

import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

import com.googlecode.jpattern.core.util.CharacterEncoding;

/**
 * 
 * @author Francesco Cina'
 *
 * 16/giu/2010
 */
public class XmlFileWriterStrategy implements IXmlWriterStrategy {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private StringBuffer filename;
	private StringBuffer path;
	private CharacterEncoding characterEncoding;

	public XmlFileWriterStrategy( StringBuffer path, StringBuffer filename, CharacterEncoding characterEncoding ) {
		this.filename = filename;
		this.path = path;
		this.characterEncoding = characterEncoding;
	}
	
	public Writer getWriter() throws Exception {
		return new OutputStreamWriter(new FileOutputStream( path.toString() + "/" + filename.toString(), true), characterEncoding.getCharset() );
	}

}
