package com.googlecode.jpattern.core.xml;

import java.util.List;

import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.SAXException;

import com.googlecode.jpattern.core.command.ErrorMessage;
import com.googlecode.jpattern.core.command.IErrorMessage;
import com.googlecode.jpattern.core.validator.AValidator;

/**
 * 
 * @author Francesco Cina'
 *
 * 04/mag/2010
 */
public class XmlValidator extends AValidator {

	private static final long serialVersionUID = 1L;
	private String xsdSchemaFilePath;
	private String xmlFilePath;

	public XmlValidator(String xmlFilePath, String xsdSchemaFilePath,  List<IErrorMessage> aValidateMessages) {
		super(aValidateMessages);
		this.xmlFilePath = xmlFilePath;
		this.xsdSchemaFilePath = xsdSchemaFilePath;
	}

	@Override
	public void validate() {
		try {
		      // define the type of schema - we use W3C:
		      String schemaLang = "http://www.w3.org/2001/XMLSchema";

		      // get validation driver:
		      SchemaFactory factory = SchemaFactory.newInstance(schemaLang);

		      // create schema by reading it from an XSD file:
		      Schema schema = factory.newSchema(new StreamSource(xsdSchemaFilePath));
		      javax.xml.validation.Validator validator = schema.newValidator();

		      // at last perform validation:
		      validator.validate(new StreamSource(xmlFilePath));

		    } catch (SAXException ex) {
//		         add(new MessageInvalidate("XmlValidator" , "Error validating file: " + xmlFilePath + " --> " + ex.getMessage()));
		         add(new ErrorMessage("XmlValidator" , ex.getMessage()));
		    } catch (Exception ex) {
		      ex.printStackTrace();
		    }

	}

}
