package com.googlecode.jpattern.core.xml;

import java.io.Writer;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ErrorMessage;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.core.util.CharacterEncoding;
import com.googlecode.jpattern.service.log.ILogger;

/**
 * 
 * @author Francesco Cina'
 *
 * 16/giu/2010
 */
public class XmlWriterCommand extends ACommand {

	private static final long serialVersionUID = 1L;
	private CharacterEncoding characterEncoding;
	private IXmlElement xmlElement;
	private IXmlWriterStrategy xmlWriterStrategy;

	public XmlWriterCommand(IXmlWriterStrategy xmlWriterStrategy, IXmlElement xmlElement, CharacterEncoding characterEncoding ) {
		this(xmlWriterStrategy, xmlElement, characterEncoding, new NullCommand());
	}
	
	public XmlWriterCommand(IXmlWriterStrategy xmlWriterStrategy, IXmlElement xmlElement, CharacterEncoding characterEncoding, ICommand aSuccessor) {
		super(aSuccessor);
		this.xmlWriterStrategy = xmlWriterStrategy;
		this.characterEncoding = characterEncoding;
		this.xmlElement = xmlElement;
	}

	@Override
	protected void internalRollBack(ICommandResult result) {
	}

	@Override
	protected void result(ICommandResult result) {
		
		ILogger logger = getProvider().getLoggerService().logger(this.getClass());
		logger.info("result", "Start Writing Response Xml");
		
		try {
	        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
	        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
	        Document document = documentBuilder.newDocument();
	
	        Element root = document.createElement( xmlElement.getName() );
	        document.appendChild(root);
	
	        buildElementRecursively(document, root, xmlElement);
	
	        //set up a transformer
	        TransformerFactory transformerFactory = TransformerFactory.newInstance();
	        transformerFactory.setAttribute("indent-number", 2);
	        Transformer transformer = transformerFactory.newTransformer();
	        //trans.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
	        transformer.setOutputProperty(OutputKeys.INDENT, "yes");
	        transformer.setOutputProperty(OutputKeys.METHOD, "xml");
	        transformer.setOutputProperty(OutputKeys.ENCODING, characterEncoding.getCharset() );
	        
	
			//create the xml tree
	        Writer xmlWriter = xmlWriterStrategy.getWriter();
	        StreamResult streamResult = new StreamResult( xmlWriter );
	        DOMSource source = new DOMSource(document);
	        transformer.transform(source, streamResult);
	        xmlWriter.close();	        
	        
			logger.debug("result", "End Writing Response Xml");
		
		} catch (Exception e) {
			result.addErrorMessage(new ErrorMessage(getClass().getName(), e.getMessage()));
			logger.error("result", "", e);
		} 		
	}

	
	private void buildElementRecursively(Document document, Element element, IXmlElement xmlElement) {
		
		// set attributes
		for ( String attributeName : xmlElement.getAttributesName()) {
			IXmlAttribute attribute = xmlElement.getAttribute(attributeName);
			element.setAttribute(attribute.getName(), attribute.getValue());
		}
		
		// set value
		if ( xmlElement.getValue().length() != 0 ) {
			//element.setTextContent( xmlElement.getValue() );
			element.appendChild( document.createTextNode( xmlElement.getValue() ) );
		}
		
        //create children element
		for ( String childName : xmlElement.getSubElementsName() ) {
			
			List<IXmlElement> childs = xmlElement.getSubElements(childName);
			
			for (IXmlElement childElement : childs) {
//				IXmlElement childElement = xmlElement.getSubElement(childName);
				Element child = document.createElement( childElement.getName() );
		        element.appendChild(child);
		        buildElementRecursively(document, child, childElement);
			}
	        
		}
	}
	
}
