package com.googlecode.jpattern.service.log;

import com.googlecode.jpattern.service.log.event.DebugEvent;
import com.googlecode.jpattern.service.log.event.ErrorEvent;
import com.googlecode.jpattern.service.log.event.ITrigger;
import com.googlecode.jpattern.service.log.event.InfoEvent;
import com.googlecode.jpattern.service.log.event.TraceEvent;
import com.googlecode.jpattern.service.log.event.Trigger;
import com.googlecode.jpattern.service.log.event.WarnEvent;

/**
 * 
 * @author Francesco Cina'
 *
 * 09/apr/2010
 */
public class LoggerServiceBuilder extends ALoggerServiceBuilder {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private IExecutor executor;

	public LoggerServiceBuilder(IExecutor executor) {
		this.executor = executor;
	}

	public ILoggerService build() {
		
		TraceEvent trace = new TraceEvent();
		DebugEvent debug = new DebugEvent();
		InfoEvent info = new InfoEvent();
		WarnEvent warn = new WarnEvent();
		ErrorEvent error = new ErrorEvent();
		
		ITrigger trigger = new Trigger( executor );
		IRoster roster = new Roster( trigger );
		
		roster.addEvent(trace);
		roster.addEvent(debug);
		roster.addEvent(info);
		roster.addEvent(warn);
		roster.addEvent(error);
		
		ILoggerService logger = new LoggerService( roster, trace, debug, info, warn, error);
		
		return logger;
	}

}
