package com.googlecode.jpattern.service.log.reader;

/**
 * 
 * @author Francesco Cina' 10/ago/2009
 *
 */
public class MessageReader implements IMessageReader {

    private static final long serialVersionUID = 1L;
    private IQueueMessages _queue;

	public MessageReader(IQueueMessages aQueue) {
		_queue = aQueue;
	}

	public String read() {
		return _queue.peek();
	}

	public String read(String lastReadedMessage) {
		
		String message = "";
		
		for (int i = (_queue.size() -1 ); i >= 0 ; i-- ){
			if ( _queue.get(i).equals(lastReadedMessage) ){
				return message;
			}
			message = _queue.get(i);
		}
		
		return message;
	}

}
