package com.googlecode.jpattern.service.log.slf4j;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.googlecode.jpattern.service.log.ILogger;

/**
 * 
 * @author Francesco Cina'
 *
 * 4 Mar 2011
 */
public class Slf4JLogger implements ILogger {

	private static final long serialVersionUID = 1L;

	private final Logger logger;

	private final ILogger iLogger;
	
	public Slf4JLogger(Class<?> aClass, ILogger iLogger) {
		this.iLogger = iLogger;
		logger = LoggerFactory.getLogger(aClass);
	}

	@Override
	public void trace(String method, String message) {
		iLogger.trace(method, message);
		logger.trace(message);
	}

	@Override
	public void debug(String method, String message) {
		iLogger.debug(method, message);
		logger.debug(message);
	}

	@Override
	public void info(String method, String message) {
		iLogger.info(method, message);
		logger.info(message);
	}

	@Override
	public void warn(String method, String message) {
		iLogger.warn(method, message);
		logger.warn(message);
	}

	@Override
	public void error(String method, String message) {
		iLogger.error(method, message);
		logger.error(message);
	}

	@Override
	public void error(String method, String message, Exception exception) {
		iLogger.error(method, message, exception);
		logger.error(message, exception);
	}

}
