package com.googlecode.jpattern.service.log.slf4j;

import com.googlecode.jpattern.service.log.ILogger;
import com.googlecode.jpattern.service.log.ILoggerService;

/**
 * 
 * @author Francesco Cina'
 *
 * 4 Mar 2011
 */
public class Slf4jLoggerService implements ILoggerService {

	private static final long serialVersionUID = 1L;
	private final ILoggerService loggerService;

	Slf4jLoggerService(ILoggerService loggerService) {
		this.loggerService = loggerService;
	}
	
	@Override
	public ILogger logger(Class<?> aClass) {
		return new Slf4JLogger(aClass, loggerService.logger(aClass));
	}
	
	@Override
	public String getName() {
		return loggerService.getName();
	}

	@Override
	public void setTraceLoggerLevel() {
		loggerService.setTraceLoggerLevel();
	}

	@Override
	public void setDebugLoggerLevel() {
		loggerService.setDebugLoggerLevel();
	}

	@Override
	public void setInfoLoggerLevel() {
		loggerService.setInfoLoggerLevel();
	}

	@Override
	public void setWarnLoggerLevel() {
		loggerService.setWarnLoggerLevel();
	}

	@Override
	public void setErrorLoggerLevel() {
		loggerService.setErrorLoggerLevel();
	}

	@Override
	public void setOffLoggerLevel() {
		loggerService.setOffLoggerLevel();
	}

	@Override
	public void setTraceLoggerLevel(String classpath) {
		loggerService.setTraceLoggerLevel(classpath);
	}

	@Override
	public void setDebugLoggerLevel(String classpath) {
		loggerService.setDebugLoggerLevel(classpath);
	}

	@Override
	public void setInfoLoggerLevel(String classpath) {
		loggerService.setInfoLoggerLevel(classpath);
	}

	@Override
	public void setWarnLoggerLevel(String classpath) {
		loggerService.setWarnLoggerLevel(classpath);
	}

	@Override
	public void setErrorLoggerLevel(String classpath) {
		loggerService.setErrorLoggerLevel(classpath);
	}

	@Override
	public void setOffLoggerLevel(String classpath) {
		loggerService.setOffLoggerLevel(classpath);
	}

	@Override
	public void setLoggerLevel(String classpath, String loggerLevel) {
		loggerService.setLoggerLevel(classpath, loggerLevel);
	}

}
