package com.googlecode.jpattern.service.mail;

import com.googlecode.jpattern.core.IServicesName;
import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ErrorMessage;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.service.mail.message.FromRecipient;
import com.googlecode.jpattern.service.mail.message.Recipient;
import com.googlecode.jpattern.service.mail.message.TransportTextMessage;

/**
 * 
 * @author Francesco Cina'
 * 
 *         04/nov/2009
 */
public class SendMailCommand extends ACommand {

	private static final long serialVersionUID = 1L;
	
    private static final String COMMAND_ACTION = "sendmail.failed";
    private static final String COMMAND = "SendMailCommand";

	private StringBuffer from;

	private StringBuffer to;

	private StringBuffer body;

	private StringBuffer subject;

	public SendMailCommand(StringBuffer from, StringBuffer to, StringBuffer subject, StringBuffer body) {
		this(from, to, subject, body, new NullCommand());
	}

	public SendMailCommand(StringBuffer from, StringBuffer to, StringBuffer subject, StringBuffer body, ICommand aSuccessor) {
		super(aSuccessor);
		this.from = from;
		this.to = to;
		this.body = body;
		this.subject = subject;
	}

	
	protected void internalRollBack() {
	}

	protected void result(ICommandResult result) {
		try {
			IMailService mailService = (IMailService) getProvider().getService( IServicesName.MAIL_SENDER_SERVICE );
			IMailSender mailSender = mailService.mailSender();
	
			MailRecipients recipients = new MailRecipients();
			TransportMailMessage transportMailMessage = new TransportMailMessage();
			
			createMailObjects(recipients, transportMailMessage);
					
			// Aggiungo mittente e destinari al mailsender
			mailSender.recipients(recipients);
	
			// invio la mail
			createMessages(result, mailSender.send(transportMailMessage));
		} catch (Exception e) {
			result.addErrorMessage(new ErrorMessage(COMMAND, e.getMessage()));
		}

	}

	protected void createMessages(ICommandResult result, boolean valid) {
		if (!valid) {
			result.getErrorMessages().add(new ErrorMessage(COMMAND, COMMAND_ACTION));
		}

	}

	private void createMailObjects(MailRecipients recipients, TransportMailMessage transportMailMessage) {

		// Creo mittente
		Recipient recipientFROM = new Recipient(from.toString());
		FromRecipient fromrecipient = new FromRecipient(recipientFROM);
		recipients.from(fromrecipient);

		// Creo destinatario
		recipients.addRecipient(new Recipient( to.toString() ));

		// creo il subject
		TransportTextMessage transportTextMessage = new TransportTextMessage(subject.toString());

		// creo il body
		TransportTextMessage transportBodyTextMessage = new TransportTextMessage(body.toString());

		// creo la mail ed aggiungo subject e body
		transportMailMessage.subject(transportTextMessage);
		transportMailMessage.body(transportBodyTextMessage);
	}

	@Override
	protected void internalRollBack(ICommandResult result) {
	}
	
}
