package com.googlecode.jpattern.service.transaction;

import com.googlecode.jpattern.core.IProvider;
import com.googlecode.jpattern.core.command.IResult;

/**
 * 
 * @author Francesco Cina'
 *
 * 28 Mar 2011
 */
public abstract class ATransactionManager {

	/**
	 * Begin of a new transaction
	 * @param provider the IProvider to use
	 * @return 
	 */
	public abstract boolean beginTransaction(IProvider provider);
	
	/**
	 * Close the current transaction. 
	 * Commits if the result of the transaction is valid, otherwise rollbacks it.
	 * @param provider the IProvider to use
	 * @param result the result of the transaction execution
	 */
	public void closeTransaction(IProvider provider , IResult result) {
		if (result.isValid()) {
			commit(provider);
			return;
		}
		rollback(provider);
	}
	
	public abstract void setForceReadOnly(boolean forceReadOnly);

	protected abstract void commit(IProvider provider);
	
	protected abstract void rollback(IProvider provider);

	public abstract void setForceNewTransaction(boolean forceNewTransaction);
	
	public abstract boolean isClosed();
	
}
