package com.googlecode.jpattern.service.transaction;

import java.util.List;

import com.googlecode.jpattern.core.IService;

/**
 * 
 * @author Francesco Cina'
 *
 * 28 Mar 2011
 * 
 * This service manage the available ATransactionManager objects used to manage
 * transaction for the application.
 * If not otherwise specified the ACommandFacade will use the defaultTransactionManager
 * here configured. 
 */
public interface ITransactionService extends IService {

	/**
	 * Return the ATransactionManager object with the specified name.
	 * If no one is found, a NullTransactionManager is returned.
	 * @param transactionManagerName
	 * @return
	 */
	ATransactionManager getTransactionManager(String transactionManagerName);
	
	/**
	 * 
	 * @return the default ATransactionManager 
	 */
	ATransactionManager getDefaultTransactionManager();
	
	List<String> getTransactionManagerNames();
	
	String getDefaultTransactionManagerName();
	
}
