package com.googlecode.jpattern.core;

import java.util.HashMap;
import java.util.Map;

import com.googlecode.jpattern.service.log.ALoggerServiceBuilder;
import com.googlecode.jpattern.service.mail.AMailServiceBuilder;
import com.googlecode.jpattern.service.transaction.ATransactionServiceBuilder;


/**
 * 
 * @author Francesco Cina'
 *
 * 29/gen/2011
 */
public class ApplicationSystem implements ISystem {

    private static final long serialVersionUID = 1L;
    private Map<String, IService> serviceMap = new HashMap<String, IService>();

    public ApplicationSystem() {};

    @Override
    public void buildService(AServiceBuilder aServiceBuilder) {
        serviceMap.put(aServiceBuilder.getName(), aServiceBuilder.build());
    }
    
	@Override
	public void buildLoggerService(ALoggerServiceBuilder aLoggerServiceBuilder) {
		buildService(aLoggerServiceBuilder);
	}

	@Override
	public void buildMailService(AMailServiceBuilder aMailServiceBuilder) {
		buildService(aMailServiceBuilder);
	}
	
	@Override
	public void buildTransactionService(ATransactionServiceBuilder aTransactionServiceBuilder) {
		buildService(aTransactionServiceBuilder);
	}
	
    @Override
    public void remove(String aServiceName) {
        serviceMap.remove(aServiceName);
    }    
    
    @Override
    public boolean contains(String aServiceName) {
        return serviceMap.containsKey(aServiceName);
    }        

    @Override
    public void removeAllServices() {
        serviceMap.clear();
    }

	@Override
	public Map<String, IService> getServiceMap() {
		return serviceMap;
	}

}
