package com.googlecode.jpattern.core;

import java.io.Serializable;
import java.util.Map;

import com.googlecode.jpattern.service.log.ALoggerServiceBuilder;
import com.googlecode.jpattern.service.mail.AMailServiceBuilder;
import com.googlecode.jpattern.service.transaction.ATransactionServiceBuilder;

/**
 * 
 * @author Francesco Cina'
 *
 * 29/gen/2011
 */
public interface ISystem extends Serializable {

    void buildService(AServiceBuilder aServiceBuilder);
    
    void buildLoggerService(ALoggerServiceBuilder aLoggerServiceBuilder);
    
    void buildMailService(AMailServiceBuilder aMailServiceBuilder);
    
    void buildTransactionService(ATransactionServiceBuilder aTransactionServiceBuilder);
    
    void remove(String aServiceName);
    
    void removeAllServices();
    
    boolean contains(String aServiceName);

	Map<String, IService> getServiceMap();
}
