package com.googlecode.jpattern.core;

import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.service.log.ILoggerService;
import com.googlecode.jpattern.service.log.NullLoggerService;
import com.googlecode.jpattern.service.mail.IMailService;
import com.googlecode.jpattern.service.mail.NullMailService;
import com.googlecode.jpattern.service.transaction.ITransactionService;
import com.googlecode.jpattern.service.transaction.NullTransactionService;

/**
 * 
 * @author Francesco Cina'
 *
 * 29/gen/2011
 */
public class NullProvider implements IProvider {

    private static final long serialVersionUID = 1L;

    public IService getService(String aServiceName) {
        return new NullService();
    }

	public boolean contains(String aServiceName) {
		return false;
	}

	@Override
	public ILoggerService getLoggerService() {
		return new NullLoggerService();
	}

	@Override
	public IMailService getMailService() {
		return new NullMailService();
	}

	@Override
	public ITransactionService getTransactionService() {
		return new NullTransactionService();
	}

	@Override
	public void accept(ICommand command) {
		command.visit(this);
	}

}
