package com.googlecode.jpattern.core.command;

import java.io.Serializable;

import com.googlecode.jpattern.core.IProvider;

/**
 * 
 * @author Francesco Cina'
 *
 * 28/gen/2011
 */
public abstract class ICommand implements Serializable  {
    
	private static final long serialVersionUID = 1L;

	public abstract void visit(IProvider provider);
 
    /**
     * This method launch the execution of the command (or chain of commands) using the default
     * default Executor.
     * This command is the same of:
     * exec(new ConditionalCommandExecutor());
     * @return the result of the execution
     */
	public abstract  ICommandResult exec();
    
    /**
     * This method launch the execution of the command (or chain of commands).
     * Every command in the chain will be managed by an ICommandExecutor object
     * @param aCommandExecutor the pool in which the command will runs
     * @return the result of the execution
     */
	public abstract ICommandResult exec(ICommandExecutor aCommandExecutor);
	
	abstract void doGlobalRollback(ICommandResult result);
	
	abstract ICommandResult prepareCommandResult();
	
	abstract void doExec(ICommandExecutor aCommandExecutor, ICommandResult result);
	
}
