package com.googlecode.jpattern.core.command;

import com.googlecode.jpattern.shared.result.IErrorMessage;
import com.googlecode.jpattern.shared.result.IResult;


/**
 * 
 * @author Francesco Cina'
 *
 * 27/feb/2011
 */
public abstract class ICommandResult implements IResult {
	
	private static final long serialVersionUID = 1L;

	public abstract boolean isValid();
	
	public abstract boolean isExecutionEnd();
	
	public abstract void waitExecutionEnd() throws InterruptedException;
	
	public abstract void addErrorMessage(IErrorMessage errorMessage);
    
	protected abstract void commandStartExecution(ICommand aCommand);
	
	protected abstract void commandEndExecution(ICommand aCommand);

	protected abstract void removeAllCommands();
	
	public abstract String asString();
	
}
