package com.googlecode.jpattern.core.command;


/**
 * 
 * @author Francesco Cina'
 *
 * 23 Apr 2011
 */
public class ManagedChainStrategy implements IChainStrategy {

	@Override
	public void globalExecEnd(ACommand aCommand, ICommandResult result) {
		if (result.isValid()) {
			result.removeAllCommands();
		} else {
			aCommand.doGlobalRollback(result);
		}
	}

	@Override
	public void localExecEnd(ACommand aCommand, ICommandResult localResult, ICommandResult globalResult) {
		if (!localResult.isValid()) {
			globalResult.getErrorMessages().addAll(localResult.getErrorMessages());
		}
	}

}
