package com.googlecode.jpattern.core.command;


/**
 * 
 * @author Francesco Cina'
 *
 * 23 Apr 2011
 */
public class UnmanagedChainStrategy implements IChainStrategy {

	@Override
	public void globalExecEnd(ACommand aCommand, ICommandResult result) {
	}

	@Override
	public void localExecEnd(ACommand aCommand, ICommandResult localresult, ICommandResult globalResult) {
		if (!localresult.isValid()) {
			aCommand.doLocalRollback(localresult);
			globalResult.getErrorMessages().addAll(localresult.getErrorMessages());
		}
	}
}
