package com.googlecode.jpattern.core.command.facade;

import java.io.Serializable;

import com.googlecode.jpattern.core.IProvider;
import com.googlecode.jpattern.core.NullProvider;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.service.log.ILogger;
import com.googlecode.jpattern.shared.result.facade.ICommandFacadeResult;

/**
 * 
 * @author Francesco Cina'
 *
 * 25 Feb 2011
 * 
 * This class is used as a entry point for the execution of a chain of commands.
 * 
 */
public abstract class ACommandFacade<E> implements Serializable {

    private static final long serialVersionUID = 1L;

    private IProvider provider;
	private ILogger logger;

	public ACommandFacade(IProvider provider) {
		this.provider = provider;
	}
	
    protected final synchronized void accept(final ICommand aCommand) {
        aCommand.visit(provider);
    }
    
    public final synchronized ICommandFacadeResult<E> exec() {
    	return execute();
    }
    
    protected final synchronized IProvider getProvider() {
    	if (provider==null) {
    		provider = new NullProvider();
    	}
    	return provider;
    }
    
    protected abstract ICommandFacadeResult<E> execute();
    
	protected final ILogger getLogger() {
		if (logger==null) {
			logger = getProvider().getLoggerService().logger(this.getClass());
		}
		return logger;
	}

}
