package com.googlecode.jpattern.core.textfiles;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.service.log.ILogger;
import com.googlecode.jpattern.shared.result.ErrorMessage;

/**
 * 
 * @author Francesco Cina'
 *
 * 10/giu/2010
 */
public class FileCreateCommand extends ACommand {

	private static final long serialVersionUID = 1L;
	
	private ILogger logger; 
	private FileWrapper fileWrapper;
	private StringBuffer fileContent;
	private StringBuffer fileName;
	private IResource resource;
	
	public FileCreateCommand(IResource resource, StringBuffer fileName, StringBuffer fileContent, FileWrapper fileWrapper) {
		this( resource, fileName, fileContent, fileWrapper, new NullCommand() );
	}
	
	public FileCreateCommand(IResource resource, StringBuffer fileName, StringBuffer fileContent, FileWrapper fileWrapper, ICommand aSuccessor) {
		super(aSuccessor);
		
		this.resource = resource;
		this.fileName = fileName;
		this.fileContent = fileContent;
		this.fileWrapper = fileWrapper;
	}
	
	@Override
	protected void internalRollBack(ICommandResult result) {
		
	}

	@Override
	protected void result(ICommandResult result) {
		logger = getProvider().getLoggerService().logger(FileCreateCommand.class);
		logger.info("result", "Creating file " + fileName.toString() + " in " + resource.getPath());
		try {
			IFile newFile = resource.create( fileName.toString(), fileContent.toString() );
			fileWrapper.setFile(newFile);
			if ( newFile.exists() ){
				logger.debug("result", "Created file " + newFile.getPath());
			}
			else {
				logger.error("result", "Error creating file " + fileName);
				result.addErrorMessage( new ErrorMessage("FileCreateCommand", "Error creating file " + fileName) );
			}
			
		} catch (Exception e) {
			logger.error("result", "Error creating file " + fileName, e);
			result.addErrorMessage( new ErrorMessage("FileCreateCommand", "Error creating file " + fileName + ": " + e.getMessage()) );
		}
	}

}
