package com.googlecode.jpattern.core.xml;

import java.io.FileReader;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.core.util.GenericWrapper;
import com.googlecode.jpattern.service.log.ILogger;
import com.googlecode.jpattern.shared.result.ErrorMessage;

/**
 * 
 * @author Francesco Cina'
 * 
 *         16/giu/2010
 */
public class XmlReaderCommand extends ACommand {

	private static final long serialVersionUID = 1L;
	private StringBuffer xmlFilePath;
	private IXmlReaderStrategy xmlParserStrategy;
	private GenericWrapper<Boolean> trimValues;

	public XmlReaderCommand(StringBuffer xmlFilePath, GenericWrapper<Boolean> trimValues, IXmlReaderStrategy xmlParserStrategy) {
		this(xmlFilePath, trimValues, xmlParserStrategy, new NullCommand());
	}

	public XmlReaderCommand(StringBuffer xmlFilePath, GenericWrapper<Boolean> trimValues, IXmlReaderStrategy xmlParserStrategy, ICommand aSuccessor) {
		super(aSuccessor);
		this.xmlFilePath = xmlFilePath;
		this.xmlParserStrategy = xmlParserStrategy;
		this.trimValues = trimValues;
	}

	@Override
	protected void internalRollBack(ICommandResult result) {
	}

	@Override
	protected void result(ICommandResult result) {
		ILogger logger = getProvider().getLoggerService().logger(XmlReaderCommand.class);
		logger.info("result", "Starting build POJO from xml file " + xmlFilePath.toString() );
		try {
			// Create SAX 2 parser...
			XMLReader xr = XMLReaderFactory.createXMLReader();
			// Set the ContentHandler...
			xr.setContentHandler(new SaxXmlDefaultHandler( xmlParserStrategy , trimValues.getValue() ));
			// Parse the file...
			xr.parse(new InputSource(new FileReader(xmlFilePath.toString())));

		} catch (Exception e) {
			result.addErrorMessage( new ErrorMessage("XmlParserCommand", "Error parsing xml file " + xmlFilePath.toString()));
			logger.error("result", "error parsing xml file " + xmlFilePath.toString(), e);
		}
	}

}
