package com.googlecode.jpattern.service.log;

import java.util.Date;

import com.googlecode.jpattern.service.log.event.DebugEvent;
import com.googlecode.jpattern.service.log.event.ErrorEvent;
import com.googlecode.jpattern.service.log.event.InfoEvent;
import com.googlecode.jpattern.service.log.event.Message;
import com.googlecode.jpattern.service.log.event.MessageException;
import com.googlecode.jpattern.service.log.event.TraceEvent;
import com.googlecode.jpattern.service.log.event.WarnEvent;

/**
 * 
 * @author Francesco Cina'
 *
 * 09/apr/2010
 */
public class Logger implements ILogger {

	private static final long serialVersionUID = 1L;
	private TraceEvent trace;
	private DebugEvent debug;
	private InfoEvent info;
	private WarnEvent warn;
	private ErrorEvent error;
	private String className;

	public Logger(Class<?> aClass, TraceEvent trace, DebugEvent debug, InfoEvent info, WarnEvent warn, ErrorEvent error) {
		this.trace = trace;
		this.debug = debug;
		this.info = info;
		this.warn = warn;
		this.error = error;
		this.className = aClass.getName(); 
	}

	public void debug(String method, String message) {
		debug.fireMessage( new Message( className , method , message , new Date() ) );
	}

	public void error(String method, String message) {
		error.fireMessage( new MessageException( className , method , message , new Date() ) );
	}

	public void error(String method, String message, Exception exception) {
		error.fireMessage( new MessageException( className , method , message , new Date() , exception ) );
	}

	public void info(String method, String message) {
		info.fireMessage( new Message( className , method , message , new Date() ) );
	}

	public void trace(String method, String message) {
		trace.fireMessage( new Message( className , method , message , new Date() ) );
	}

	public void warn(String method, String message) {
		warn.fireMessage( new Message( className , method , message , new Date() ) );
	}

}
