package com.googlecode.jpattern.service.log;

import java.io.PrintWriter;
import java.util.Map.Entry;

import com.googlecode.jpattern.service.log.file.ILogFileExecutorStrategy;
import com.googlecode.jpattern.service.log.file.ILogFileWriter;
import com.googlecode.jpattern.service.log.file.LogFileExecutor;
import com.googlecode.jpattern.service.log.file.RollingLogFileExecutorStrategy;
import com.googlecode.jpattern.service.mail.IMailService;

/**
 * 
 * @author Francesco Cina'
 *
 * 09/apr/2010
 */
public class SimpleLoggerServiceBuilder extends ALoggerServiceBuilder {

	private static final long serialVersionUID = 1L;
	private ILoggerConfig loggerConfig;
	private IMailService mailService;

	public SimpleLoggerServiceBuilder(ILoggerConfig loggerConfig, IMailService mailService) {
		this.loggerConfig = loggerConfig;
		this.mailService = mailService;
	}

	public ILoggerService build() {
		
		//Configuro Logging su File
		ILogFileExecutorStrategy fileExecutorStrategy = new RollingLogFileExecutorStrategy(loggerConfig.getLogFile(), loggerConfig.getMaxFileSize(), ILogFileWriter.MEGABYTE, loggerConfig.getMaxFileBackupNumber());
		IExecutor fileExecutor = new LogFileExecutor(fileExecutorStrategy);
		fileExecutor.setLoggerLevel(loggerConfig.getFileLoggerlevel());
		
		//Configuro Logging su console
		PrintWriter printWriter = new PrintWriter(System.out, true);
		IExecutor consoleExecutor = new PrintWriterExecutor( printWriter , fileExecutor);
		consoleExecutor.setLoggerLevel(loggerConfig.getConsoleLoggerlevel());
		
		//Configuro Logging su Mail
		IExecutor mailExecutor = new MailExecutor(mailService, loggerConfig.getMailTo(), loggerConfig.getMailFrom(), loggerConfig.getMailSubject(), consoleExecutor);
		mailExecutor.setLoggerLevel(loggerConfig.getMailLoggerlevel());
		
		
		ILoggerService loggerService = (ILoggerService) new LoggerServiceBuilder( mailExecutor ).build(); 
		for( Entry<String,String> entry : loggerConfig.getClasspathLoggerLevelMap().entrySet() ) {
			loggerService.setLoggerLevel(entry.getKey(), entry.getValue());
		}
		
		return loggerService;
	}

}
