package com.googlecode.jpattern.service.log.event;

import java.util.Date;

import com.googlecode.jpattern.service.log.IExecutor;

/**
 * 
 * @author Francesco Cina'
 *
 * 09/apr/2010
 */
public class ErrorEvent extends AEvent {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public static String EVENT_NAME = "ERROR";
	private MessageException message;

	public ErrorEvent() {
		super( EVENT_NAME );
	}
	
	public void execute(IExecutor executor) {
		executor.execute(this);
	}
	
	public MessageException getMessage() {
		if (message == null) {
			return new MessageException("","","", new Date(), new NullException());
		}
		return message;
	}

	public synchronized void fireMessage(MessageException message) {
		if ( !isIgnoredPath( message.getClassName() ) ) {
			this.message = message;
			fire();
		}
	}
	
}
