package com.googlecode.jpattern.service.log.reader;

/**
 * @author Francesco Cinà 07/ago/2009
 */
public class LoggerReaderService implements ILoggerReaderService {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private IQueueMessages _aQueue;

    private String _name;

    public LoggerReaderService(String aName, IQueueMessages aInfoQueue) {
        _name = aName;
        _aQueue = aInfoQueue;
    }

    public String getName() {
        return _name;
    }

	public IMessageReader messageReader() {
		return new MessageReader(_aQueue);
	}

	public IMessageReader messageReader(IFilter aFilter) {
		return new MessageStringFilteredReader( new MessageReader(_aQueue), aFilter);
	}
	


}
