package com.googlecode.jpattern.service.log.reader;

public class MessageStringFilteredReader implements IMessageReader {

    private static final long serialVersionUID = 1L;

    private IMessageReader _messageReader;

    private IFilter _filter;

    public MessageStringFilteredReader(IMessageReader aMessageReader, IFilter aFilter) {
        _filter = aFilter;
        _messageReader = aMessageReader;
    }

    public String read() {
        return _filter.what(_messageReader.read());
    }

	public String read(String lastReadedMessage) {
		return _filter.what(_messageReader.read(lastReadedMessage));
	}

}
