package com.googlecode.jpattern.service.log.reader;

import java.util.Iterator;
import java.util.LinkedList;

/**
 * @author Francesco Cinà 07/ago/2009
 */

public class QueueMessages implements IQueueMessages {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private int _maxCodaLenght = 1;

    private LinkedList<String> _messageList = new LinkedList<String>();

    public QueueMessages(int maxCodaLength) {
        if (maxCodaLength > 1) {
            _maxCodaLenght = maxCodaLength;
        }
    }

    public int size() {
        return _messageList.size();
    }

    public boolean offer(String aMessage) {
        if (_messageList.size() >= _maxCodaLenght) {
            _messageList.poll();
        }
        return _messageList.offer(aMessage);
    }

    public String peek() {
        if (_messageList.size() == 0) {
            return "";
        }
        return _messageList.peek();
    }

    public String poll() {
        if (_messageList.size() == 0) {
            return "";
        }
        return _messageList.poll();
    }

	public String get(int index) {
		if (index > size()) {
			return "";
		}
		return _messageList.get(index);
	}

	public Iterator<String> iterator() {
		return _messageList.listIterator();
	}

}
