package com.googlecode.jpattern.service.log.reader;

import com.googlecode.jpattern.core.IServicesName;
import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;


/**
 * 
 * @author Francesco Cina'
 *
 * 6 May 2011
 */
public class TailCommand extends ACommand {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    private StringBuffer _outputMessageString;

    private IFilter _messageFilter;

    private String _lastReadedMessage;

    public TailCommand(StringBuffer aOutputMessageString, String lastReadedMessage, IFilter aMessageFilter) {
        this(aOutputMessageString, lastReadedMessage, aMessageFilter, new NullCommand());
    }

    public TailCommand(StringBuffer aOutputMessageString, String lastReadedMessage, IFilter aMessageFilter, ICommand aPreviousCommand) {
        super(aPreviousCommand);
        _outputMessageString = aOutputMessageString;
        _messageFilter = aMessageFilter;
        _lastReadedMessage = lastReadedMessage;
    }

    protected void internalRollBack(ICommandResult result) {
    }

    protected void result(ICommandResult result) {
        _outputMessageString.setLength(0);
        IMessageReader messageReader = ((ILoggerReaderService) getProvider().getService(IServicesName.LOGGER_READER_SERVICE)).messageReader(_messageFilter);
        _outputMessageString.append(messageReader.read(_lastReadedMessage));
    }

}
