package com.googlecode.jpattern.service.log.slf4j;

import com.googlecode.jpattern.service.log.ALoggerServiceBuilder;
import com.googlecode.jpattern.service.log.ILoggerService;

/**
 * 
 * @author Francesco Cina'
 *
 * 4 Mar 2011
 */
public class Slf4jLoggerServiceBuilder extends ALoggerServiceBuilder {

	private static final long serialVersionUID = 1L;
	private final ILoggerBackendConfigurator loggerBackendConfigurator;
	private final ALoggerServiceBuilder loggerServiceBuilder;
	
	public Slf4jLoggerServiceBuilder(ALoggerServiceBuilder loggerServiceBuilder, ILoggerBackendConfigurator loggerBackendConfigurator) {
		this.loggerServiceBuilder = loggerServiceBuilder;
		this.loggerBackendConfigurator = loggerBackendConfigurator;
	}

	@Override
	public ILoggerService build() {
		loggerBackendConfigurator.configure();
		return new Slf4jLoggerService( loggerServiceBuilder.build() );
	}

}
