package com.googlecode.jpattern.service.messageManager;

import java.util.Map;

/**
 * 
 * @author Francesco Cina'
 *
 * 04/nov/2009
 */
public class MessageManagerService implements IMessageManager {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String name;
	private Map<String, String> messageMap;

	public MessageManagerService(String name, IMessageManagerConfig messageConfig) {
		this.name = name;
		this.messageMap = messageConfig.getMessageMap();
	}

	public String getMessage(String messageKey) {
		String returnedValue = "";
		
		if (messageMap.containsKey(messageKey)){
			returnedValue = (String) messageMap.get(messageKey);
		}
		
		return returnedValue;
	}
	
	public String getName() {
		return name;
	}

}
