package com.googlecode.jpattern.service.transaction;

/**
 * 
 * @author Francesco Cina'
 *
 * 22 Apr 2011
 */
public abstract class ATransactionDefinition {

	protected ATransactionManager transactionManager;
	private String transactionManagerName = "";
	private boolean forceReadOnly = false;
	private boolean forceNewTransaction = false;
	private boolean newTransaction = false;

	public final boolean isForceNewTransaction() {
		return forceNewTransaction;
	}

	public final void setForceNewTransaction(boolean forceNewTransaction) {
		this.forceNewTransaction = forceNewTransaction;
	}

	protected void setTransactionManager(ATransactionManager transactionManager) {
		this.transactionManager = transactionManager;
	}

	protected abstract void setTransactionManagerFromService(ITransactionService transactionService);

	public final String getTransactionManagerName() {
		return transactionManagerName;
	}

	protected final void setTransactionManagerName(String transactionManagerName) {
		if (transactionManagerName != null) {
			this.transactionManagerName = transactionManagerName;
		}
	}

	public final boolean isForceReadOnly() {
		return forceReadOnly;
	}

	protected final ATransactionManager getTransactionManager() {
		if (transactionManager==null) {
			transactionManager = new NullTransactionManager();
		}
		return transactionManager;
	}

	public final void setForceReadOnly(boolean forceReadOnly) {
		this.forceReadOnly = forceReadOnly;
	}

	protected void setNewTransaction(boolean newTransaction) {
		this.newTransaction = newTransaction;
	}

	public boolean isNewTransaction() {
		return newTransaction;
	}

	public final boolean isTransactionClosed() {
		return getTransactionManager().isClosed();
	}

}
