package com.googlecode.jpattern.service.transaction;

import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import com.googlecode.jpattern.core.IProvider;

/**
 * 
 * @author Francesco Cina'
 *
 * 28 Mar 2011
 * 
 * Manage of the transaction using the PlatformTransactionManager implementation
 * of Spring
 */
public class SpringTransactionManager extends ATransactionManager {

	private boolean forceReadOnly = false;

	private final PlatformTransactionManager platformTransactionManager;

	private TransactionStatus transactionStatus;

	private boolean forceNewTransaction;

	public SpringTransactionManager(PlatformTransactionManager platformTransactionManager) {
		this.platformTransactionManager = platformTransactionManager;
	}

	@Override
	public void setForceReadOnly(boolean forceReadOnly) {
		this.forceReadOnly = forceReadOnly;
	}
	
	@Override
	public void setForceNewTransaction(boolean forceNewTransaction) {
		this.forceNewTransaction = forceNewTransaction;
	}

	@Override
	public boolean beginTransaction(IProvider provider) {
		DefaultTransactionDefinition def = new DefaultTransactionDefinition();
		def.setReadOnly(forceReadOnly);
		if (forceNewTransaction) {
			def.setPropagationBehavior( DefaultTransactionDefinition.PROPAGATION_REQUIRES_NEW );
		}
		transactionStatus = platformTransactionManager.getTransaction(def);
		if (forceReadOnly) {
			transactionStatus.setRollbackOnly();
		}
		return transactionStatus.isNewTransaction();
	}

	@Override
	protected void commit(IProvider provider) {
		if (!isClosed()) {
			platformTransactionManager.commit(transactionStatus);
		}
	}

	@Override
	protected void rollback(IProvider provider) {
		if (!isClosed()) {
			platformTransactionManager.rollback(transactionStatus);
		}
	}

	@Override
	public boolean isClosed() {
		if (transactionStatus != null) {
			return transactionStatus.isCompleted();
		}
		return true;
	}
}
