package com.googlecode.jpattern.service.transaction;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.service.log.ILogger;

/**
 * 
 * @author Francesco Cina'
 *
 * 22 Apr 2011
 */
public class TransactionBeginCommand extends ACommand {

	private static final long serialVersionUID = 1L;
	private ILogger logger;
	private ATransactionManager transactionManager;
	private final ATransactionDefinition transactionDefinition;
	
	public TransactionBeginCommand( ATransactionDefinition transactionDefinition ) {
		this( transactionDefinition, new NullCommand());
	}
	
	public TransactionBeginCommand( ATransactionDefinition transactionDefinition, ICommand previousCommand) {
		super(previousCommand);
		this.transactionDefinition = transactionDefinition;
	}

	@Override
	protected void result(ICommandResult result) {
		logger = getLogger();
		logger.debug("result", "Starting transaction with transactionManager: " + transactionDefinition.getTransactionManagerName());
		transactionDefinition.setTransactionManagerFromService(getProvider().getTransactionService());
		ATransactionManager localTransactionManager = transactionDefinition.getTransactionManager();
		localTransactionManager.setForceReadOnly( transactionDefinition.isForceReadOnly() );
		localTransactionManager.setForceNewTransaction( transactionDefinition.isForceNewTransaction() );
		transactionDefinition.setNewTransaction( localTransactionManager.beginTransaction(getProvider()) );
		
		if (!transactionDefinition.isNewTransaction()) {
			transactionDefinition.setTransactionManagerFromService( new NullTransactionService() );
			transactionManager = new NullTransactionManager();
		} else {
			transactionManager = localTransactionManager;
		}
	}

	@Override
	protected void internalRollBack(ICommandResult result) {
		logger.info("internalRollBack", "Rollback transaction with transactionManager: " + transactionDefinition.getTransactionManagerName());
		transactionManager.rollback(getProvider());
	}


}
