package com.googlecode.jpattern.service.transaction;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;

/**
 * 
 * @author Francesco Cina'
 *
 * 22 Apr 2011
 */
public class TransactionCommitCommand extends ACommand {

	private static final long serialVersionUID = 1L;
	private final ATransactionDefinition transactionDefinition;

	public TransactionCommitCommand(ATransactionDefinition transactionDefinition) {
		this(transactionDefinition , new NullCommand());
	}

	public TransactionCommitCommand(ATransactionDefinition transactionDefinition, ICommand previousCommand) {
		super(previousCommand);
		this.transactionDefinition = transactionDefinition;
	}

	@Override
	protected void result(ICommandResult result) {
		getLogger().debug("result", "Commit transaction with transactionManager: " + transactionDefinition.getTransactionManagerName());
		transactionDefinition.getTransactionManager().commit(getProvider());
	}

	@Override
	protected void internalRollBack(ICommandResult result) {
	}

}
