/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.maven;

import com.googlecode.jslint4java.JSLint;
import com.googlecode.jslint4java.JSLintBuilder;
import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.Option;
import com.googlecode.jslint4java.UnicodeBomInputStream;
import com.googlecode.jslint4java.formatter.JSLintResultFormatter;
import com.googlecode.jslint4java.formatter.JSLintXmlFormatter;
import com.googlecode.jslint4java.formatter.PlainFormatter;
import com.googlecode.jslint4java.maven.FileLister;
import com.googlecode.jslint4java.maven.ReportWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSLintMojo
extends AbstractMojo {
    private static final String DEFAULT_INCLUDES = "**/*.js";
    private static final String JSLINT_XML = "jslint.xml";
    private final List<String> excludes = new ArrayList<String>();
    private final List<String> includes = new ArrayList<String>();
    private File defaultSourceFolder;
    private File[] sourceFolders = new File[0];
    private final Map<String, String> options = new HashMap<String, String>();
    private String encoding = "UTF-8";
    private File outputFolder = new File("target");
    private boolean failOnError = true;
    private File jslintSource;
    private long timeout;

    void addOption(Option sloppy, String value) {
        this.options.put(sloppy.name().toLowerCase(Locale.ENGLISH), value);
    }

    private void applyDefaults() {
        if (this.includes.isEmpty()) {
            this.includes.add(DEFAULT_INCLUDES);
        }
        if (this.sourceFolders.length == 0) {
            this.sourceFolders = new File[]{this.defaultSourceFolder};
        }
    }

    private void applyOptions(JSLint jsLint) throws MojoExecutionException {
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            Option option;
            if (entry.getValue() == null || entry.getValue().equals("")) continue;
            try {
                option = Option.valueOf((String)entry.getKey().toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new MojoExecutionException("unknown option: " + entry.getKey());
            }
            jsLint.addOption(option, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        JSLint jsLint = this.applyJSlintSource();
        this.applyDefaults();
        this.applyOptions(jsLint);
        List<File> files = this.getFilesToProcess();
        int failures = 0;
        ReportWriter reporter = new ReportWriter(new File(this.outputFolder, JSLINT_XML), (JSLintResultFormatter)new JSLintXmlFormatter());
        try {
            reporter.open();
            for (File file : files) {
                JSLintResult result = this.lintFile(jsLint, file);
                failures += result.getIssues().size();
                this.logIssues(result, reporter);
            }
        }
        finally {
            reporter.close();
        }
        if (failures > 0) {
            String message = "JSLint found " + failures + " problems in " + files.size() + " files";
            if (this.failOnError) {
                throw new MojoFailureException(message);
            }
            this.getLog().info((CharSequence)message);
        }
    }

    private JSLint applyJSlintSource() throws MojoExecutionException {
        JSLintBuilder builder = new JSLintBuilder();
        if (this.timeout > 0L) {
            builder.timeout(this.timeout);
        }
        if (this.jslintSource != null) {
            try {
                return builder.fromFile(this.jslintSource, Charset.forName(this.encoding));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cant' load jslint.js", (Exception)e);
            }
        }
        return builder.fromDefault();
    }

    String getEncoding() {
        return this.encoding;
    }

    private List<File> getFilesToProcess() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("includes=" + this.includes));
        this.getLog().debug((CharSequence)("excludes=" + this.excludes));
        ArrayList<File> files = new ArrayList<File>();
        for (File folder : this.sourceFolders) {
            this.getLog().debug((CharSequence)("searching " + folder));
            try {
                files.addAll(new FileLister(folder, this.includes, this.excludes).files());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error listing files", (Exception)e);
            }
        }
        return files;
    }

    Map<String, String> getOptions() {
        return this.options;
    }

    private JSLintResult lintFile(JSLint jsLint, File file) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("lint " + file));
        BufferedReader reader = null;
        try {
            UnicodeBomInputStream stream = new UnicodeBomInputStream((InputStream)new FileInputStream(file));
            reader = new BufferedReader(new InputStreamReader((InputStream)stream, this.getEncoding()));
            JSLintResult jSLintResult = jsLint.lint(file.toString(), (Reader)reader);
            return jSLintResult;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("file not found: " + file, (Exception)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MojoExecutionException("unsupported character encoding UTF-8", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("problem whilst linting " + file, (Exception)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void logIssues(JSLintResult result, ReportWriter reporter) {
        reporter.report(result);
        if (result.getIssues().isEmpty()) {
            return;
        }
        this.logIssuesToConsole(result);
    }

    private void logIssuesToConsole(JSLintResult result) {
        PlainFormatter formatter = new PlainFormatter();
        String report = formatter.format(result);
        for (String line : report.split("\n")) {
            this.getLog().info((CharSequence)line);
        }
    }

    public void setDefaultSourceFolder(File defaultSourceFolder) {
        this.defaultSourceFolder = defaultSourceFolder;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes.clear();
        this.excludes.addAll(excludes);
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void setIncludes(List<String> includes) {
        this.includes.clear();
        this.includes.addAll(includes);
    }

    public void setJslint(File jslintSource) {
        this.jslintSource = jslintSource;
    }

    public void setOptions(Map<String, String> options) {
        this.options.clear();
        this.options.putAll(options);
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void setSourceFolders(List<File> sourceFolders) {
        this.sourceFolders = sourceFolders.toArray(new File[sourceFolders.size()]);
    }
}

