/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.maven;

import com.google.common.io.Closeables;
import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.maven.ReportWriter;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;

public class MultiReportWriter
implements ReportWriter {
    private final List<ReportWriter> reportWriters;

    public MultiReportWriter(ReportWriter ... reportWriters) {
        this.reportWriters = Arrays.asList(reportWriters);
    }

    @Override
    public void close() {
        for (ReportWriter reportWriter : this.reportWriters) {
            Closeables.closeQuietly((Closeable)reportWriter);
        }
    }

    @Override
    public void open() {
        for (ReportWriter reportWriter : this.reportWriters) {
            reportWriter.open();
        }
    }

    @Override
    public void report(JSLintResult result) {
        for (ReportWriter reportWriter : this.reportWriters) {
            reportWriter.report(result);
        }
    }
}

