/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.graphhopper.api.GHMRequest;
import com.graphhopper.api.GHMatrixAbstractRequester;
import com.graphhopper.api.GraphHopperWeb;
import com.graphhopper.api.MatrixResponse;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GHMatrixBatchRequester
extends GHMatrixAbstractRequester {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int maxIterations = 100;
    private long sleepAfterGET = 1000L;

    public GHMatrixBatchRequester() {
    }

    public GHMatrixBatchRequester(String serviceUrl) {
        super(serviceUrl);
    }

    public GHMatrixBatchRequester setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        return this;
    }

    public GHMatrixBatchRequester setSleepAfterGET(long sleepAfterGETMillis) {
        this.sleepAfterGET = sleepAfterGETMillis;
        return this;
    }

    @Override
    public MatrixResponse route(GHMRequest ghRequest, String key) {
        StopWatch sw = new StopWatch().start();
        JSONObject requestJson = new JSONObject();
        List<Double[]> fromPointList = this.createPointList(ghRequest.getFromPoints());
        List<Double[]> toPointList = this.createPointList(ghRequest.getToPoints());
        ArrayList<String> outArraysList = new ArrayList<String>(ghRequest.getOutArrays());
        if (outArraysList.isEmpty()) {
            outArraysList.add("weights");
        }
        boolean hasElevation = false;
        requestJson.put("from_points", fromPointList);
        requestJson.put("to_points", toPointList);
        requestJson.put("out_arrays", outArraysList);
        requestJson.put("vehicle", (Object)ghRequest.getVehicle());
        requestJson.put("elevation", hasElevation);
        MatrixResponse matrixResponse = new MatrixResponse(ghRequest.getFromPoints().size(), ghRequest.getToPoints().size());
        boolean debug = ghRequest.getHints().getBool("debug", false);
        try {
            JSONObject responseJson;
            String postUrl = this.serviceUrl + "/calculate?key=" + key;
            String postResponseStr = this.postJson(postUrl, requestJson);
            if (debug) {
                this.logger.info("POST URL:" + postUrl + ", request:" + requestJson + ", response: " + postResponseStr);
            }
            if ((responseJson = this.toJSON(postUrl, postResponseStr)).has("message")) {
                matrixResponse.addError(new RuntimeException(responseJson.getString("message")));
                return matrixResponse;
            }
            if (!responseJson.has("job_id")) {
                throw new IllegalStateException("Response should contain job_id but was " + postResponseStr + ", json:" + requestJson + ",url:" + postUrl);
            }
            String id = responseJson.getString("job_id");
            for (int i = 0; i < this.maxIterations; ++i) {
                if (this.sleepAfterGET > 0L) {
                    Thread.sleep(this.sleepAfterGET);
                }
                String getUrl = this.serviceUrl + "/solution/" + id + "?key=" + key;
                String getResponseStr = this.getJson(getUrl);
                JSONObject getResponseJson = this.toJSON(getUrl, getResponseStr);
                if (debug) {
                    this.logger.info(i + " GET URL:" + getUrl + ", response: " + getResponseStr);
                }
                GraphHopperWeb.readErrors(matrixResponse.getErrors(), getResponseJson);
                if (matrixResponse.hasErrors()) break;
                if ("finished".equals(getResponseJson.getString("status"))) {
                    this.fillResponseFromJson(ghRequest, outArraysList, matrixResponse, getResponseJson.getJSONObject("solution"), hasElevation);
                    break;
                }
                if (i != this.maxIterations) continue;
                throw new IllegalStateException("Maximum number of iterations reached " + this.maxIterations + ", increasing should only be necessary if very big matrices. For small matrices contact us! info@graphhopper.com");
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return matrixResponse;
    }

    protected final List<Double[]> createPointList(List<GHPoint> list) {
        ArrayList<Double[]> outList = new ArrayList<Double[]>(list.size());
        for (GHPoint p : list) {
            outList.add(new Double[]{p.lon, p.lat});
        }
        return outList;
    }
}

