/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.graphhopper.api.GHMResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MatrixResponse {
    private String debugInfo = "";
    private final List<Throwable> errors = new ArrayList<Throwable>(4);
    private int fromCap;
    private List<GHMResponse> currentFromList;
    private final List<List<GHMResponse>> rspList;

    public MatrixResponse() {
        this(10, 10);
    }

    public MatrixResponse(int fromCap, int toCap) {
        this.fromCap = fromCap;
        this.rspList = new ArrayList<List<GHMResponse>>(toCap);
    }

    public void add(GHMResponse rsp) {
        if (this.currentFromList == null) {
            throw new IllegalStateException("call newFromList before adding");
        }
        this.currentFromList.add(rsp);
    }

    public void newFromList() {
        this.currentFromList = new ArrayList<GHMResponse>(this.fromCap);
        this.rspList.add(this.currentFromList);
    }

    public GHMResponse get(int from, int to) {
        if (this.hasErrors()) {
            throw new IllegalStateException("Cannot return response (" + from + "," + to + ") if errors occured " + this.getErrors());
        }
        if (from >= this.rspList.size()) {
            throw new IllegalStateException("Cannot get 'from' " + from + " from list with size " + this.rspList.size());
        }
        List<GHMResponse> list = this.rspList.get(from);
        if (to >= list.size()) {
            throw new IllegalStateException("Cannot get 'to' " + to + " from list with size " + list.size());
        }
        return list.get(to);
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public MatrixResponse setDebugInfo(String debugInfo) {
        if (debugInfo != null) {
            this.debugInfo = debugInfo;
        }
        return this;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public MatrixResponse addError(Throwable error) {
        this.errors.add(error);
        return this;
    }

    public MatrixResponse addErrors(Collection<Throwable> errorList) {
        this.errors.addAll(errorList);
        return this;
    }

    public String toString() {
        String addInfo = "";
        if (!this.rspList.isEmpty()) {
            addInfo = "," + this.rspList.get(0).size();
        }
        return "[" + this.rspList.size() + addInfo + "] errors:" + this.errors.toString();
    }
}

