/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.graphhopper.api.GHMRequest;
import com.graphhopper.api.GHMatrixAbstractRequester;
import com.graphhopper.api.GraphHopperWeb;
import com.graphhopper.api.MatrixResponse;
import com.graphhopper.util.shapes.GHPoint;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GHMatrixBatchRequester
extends GHMatrixAbstractRequester {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int maxIterations = 100;
    private long sleepAfterGET = 1000L;

    public GHMatrixBatchRequester() {
    }

    public GHMatrixBatchRequester(String serviceUrl) {
        super(serviceUrl);
    }

    public GHMatrixBatchRequester(String serviceUrl, OkHttpClient client) {
        super(serviceUrl, client);
    }

    public GHMatrixBatchRequester setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        return this;
    }

    public GHMatrixBatchRequester setSleepAfterGET(long sleepAfterGETMillis) {
        this.sleepAfterGET = sleepAfterGETMillis;
        return this;
    }

    @Override
    public MatrixResponse route(GHMRequest ghRequest) {
        JSONObject requestJson = new JSONObject();
        List<Double[]> fromPointList = this.createPointList(ghRequest.getFromPoints());
        List<Double[]> toPointList = this.createPointList(ghRequest.getToPoints());
        ArrayList<String> outArraysList = new ArrayList<String>(ghRequest.getOutArrays());
        if (outArraysList.isEmpty()) {
            outArraysList.add("weights");
        }
        boolean hasElevation = false;
        requestJson.put("from_points", fromPointList);
        requestJson.put("to_points", toPointList);
        requestJson.put("out_arrays", outArraysList);
        requestJson.put("vehicle", (Object)ghRequest.getVehicle());
        requestJson.put("elevation", hasElevation);
        boolean withTimes = outArraysList.contains("times");
        boolean withDistances = outArraysList.contains("distances");
        boolean withWeights = outArraysList.contains("weights");
        MatrixResponse matrixResponse = new MatrixResponse(ghRequest.getFromPoints().size(), ghRequest.getToPoints().size(), withTimes, withDistances, withWeights);
        boolean debug = ghRequest.getHints().getBool("debug", false);
        String postUrl = this.buildURLNoHints("/calculate", ghRequest);
        try {
            int i;
            JSONObject responseJson;
            String postResponseStr = this.postJson(postUrl, requestJson);
            if (debug) {
                this.logger.info("POST URL:" + postUrl + ", request:" + requestJson + ", response: " + postResponseStr);
            }
            if ((responseJson = this.toJSON(postUrl, postResponseStr)).has("message")) {
                matrixResponse.addError(new RuntimeException(responseJson.getString("message")));
                return matrixResponse;
            }
            if (!responseJson.has("job_id")) {
                throw new IllegalStateException("Response should contain job_id but was " + postResponseStr + ", json:" + requestJson + ",url:" + postUrl);
            }
            String id = responseJson.getString("job_id");
            for (i = 0; i < this.maxIterations; ++i) {
                String getResponseStr;
                if (this.sleepAfterGET > 0L) {
                    Thread.sleep(this.sleepAfterGET);
                }
                String getUrl = this.buildURLNoHints("/solution/" + id, ghRequest);
                try {
                    getResponseStr = this.getJson(getUrl);
                }
                catch (SocketTimeoutException ex) {
                    getResponseStr = this.getJson(getUrl);
                }
                JSONObject getResponseJson = this.toJSON(getUrl, getResponseStr);
                if (debug) {
                    this.logger.info(i + " GET URL:" + getUrl + ", response: " + getResponseStr);
                }
                matrixResponse.addErrors(GraphHopperWeb.readErrors(getResponseJson));
                if (matrixResponse.hasErrors()) break;
                String status = getResponseJson.getString("status");
                if ("processing".equals(status) || "waiting".equals(status)) continue;
                if ("finished".equals(status)) {
                    JSONObject solution = getResponseJson.getJSONObject("solution");
                    matrixResponse.addErrors(this.readUsableEntityError(outArraysList, solution));
                    if (matrixResponse.hasErrors()) break;
                    this.fillResponseFromJson(ghRequest, outArraysList, matrixResponse, solution, hasElevation);
                    break;
                }
                matrixResponse.addError(new RuntimeException("Status not supported: " + status + " - illegal JSON format?"));
                break;
            }
            if (i >= this.maxIterations) {
                throw new IllegalStateException("Maximum number of iterations reached " + this.maxIterations + ", increasing should only be necessary for big matrices. For smaller ones this is a bug, please contact us");
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return matrixResponse;
    }

    protected final List<Double[]> createPointList(List<GHPoint> list) {
        ArrayList<Double[]> outList = new ArrayList<Double[]>(list.size());
        for (GHPoint p : list) {
            outList.add(new Double[]{p.lon, p.lat});
        }
        return outList;
    }
}

