/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.graphhopper.api.GHMRequest;
import com.graphhopper.api.GHMatrixAbstractRequester;
import com.graphhopper.api.GraphHopperWeb;
import com.graphhopper.api.MatrixResponse;
import com.graphhopper.util.shapes.GHPoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.json.JSONObject;

public class GHMatrixSyncRequester
extends GHMatrixAbstractRequester {
    public GHMatrixSyncRequester() {
        this.initIgnore();
    }

    public GHMatrixSyncRequester(String serviceUrl, OkHttpClient client) {
        super(serviceUrl, client);
        this.initIgnore();
    }

    public GHMatrixSyncRequester(String serviceUrl) {
        super(serviceUrl, new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).build());
        this.initIgnore();
    }

    private void initIgnore() {
        this.ignoreSet.add("vehicle");
        this.ignoreSet.add("point");
        this.ignoreSet.add("from_point");
        this.ignoreSet.add("to_point");
        this.ignoreSet.add("add_array");
    }

    @Override
    public MatrixResponse route(GHMRequest ghRequest) {
        String pointsStr;
        if (ghRequest.identicalLists) {
            pointsStr = this.createPointQuery(ghRequest.getFromPoints(), "point");
        } else {
            pointsStr = this.createPointQuery(ghRequest.getFromPoints(), "from_point");
            pointsStr = pointsStr + "&" + this.createPointQuery(ghRequest.getToPoints(), "to_point");
        }
        String outArrayStr = "";
        ArrayList<String> outArraysList = new ArrayList<String>(ghRequest.getOutArrays());
        if (outArraysList.isEmpty()) {
            outArraysList.add("weights");
        }
        for (String type : outArraysList) {
            if (!type.isEmpty()) {
                outArrayStr = outArrayStr + "&";
            }
            outArrayStr = outArrayStr + "out_array=" + type;
        }
        boolean hasElevation = false;
        String url = this.buildURL("", ghRequest);
        url = url + "&" + pointsStr + "&" + outArrayStr + "&vehicle=" + ghRequest.getVehicle();
        boolean withTimes = outArraysList.contains("times");
        boolean withDistances = outArraysList.contains("distances");
        boolean withWeights = outArraysList.contains("weights");
        MatrixResponse matrixResponse = new MatrixResponse(ghRequest.getFromPoints().size(), ghRequest.getToPoints().size(), withTimes, withDistances, withWeights);
        try {
            String str = this.getJson(url);
            JSONObject getResponseJson = null;
            try {
                getResponseJson = new JSONObject(str);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot parse json " + str + " from " + url);
            }
            matrixResponse.addErrors(GraphHopperWeb.readErrors(getResponseJson));
            if (!matrixResponse.hasErrors()) {
                matrixResponse.addErrors(this.readUsableEntityError(outArraysList, getResponseJson));
            }
            if (!matrixResponse.hasErrors()) {
                this.fillResponseFromJson(ghRequest, outArraysList, matrixResponse, getResponseJson, hasElevation);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return matrixResponse;
    }

    private String createPointQuery(List<GHPoint> list, String pointName) {
        String pointsStr = "";
        for (GHPoint p : list) {
            if (!pointsStr.isEmpty()) {
                pointsStr = pointsStr + "&";
            }
            pointsStr = pointsStr + pointName + "=" + GHMatrixSyncRequester.encode(p.lat + "," + p.lon);
        }
        return pointsStr;
    }
}

