/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperAPI;
import com.graphhopper.PathWrapper;
import com.graphhopper.api.WebHelper;
import com.graphhopper.util.FinishInstruction;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.ViaInstruction;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import com.graphhopper.util.exceptions.DetailedIllegalArgumentException;
import com.graphhopper.util.exceptions.DetailedRuntimeException;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.exceptions.PointOutOfBoundsException;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperWeb
implements GraphHopperAPI {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private OkHttpClient downloader;
    private String serviceUrl;
    private String key = "";
    private boolean instructions = true;
    private boolean calcPoints = true;
    private boolean elevation = false;
    private boolean turnDescription = true;
    private String optimize = "false";
    private final Set<String> ignoreSet;
    public static final String TIMEOUT = "timeout";
    private final long DEFAULT_TIMEOUT = 5000L;

    public GraphHopperWeb() {
        this("https://graphhopper.com/api/1/route");
    }

    public GraphHopperWeb(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        this.downloader = new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(5000L, TimeUnit.MILLISECONDS).build();
        this.ignoreSet = new HashSet<String>();
        this.ignoreSet.add("calc_points");
        this.ignoreSet.add("calcpoints");
        this.ignoreSet.add("instructions");
        this.ignoreSet.add("elevation");
        this.ignoreSet.add("key");
        this.ignoreSet.add("optimize");
        this.ignoreSet.add("algorithm");
        this.ignoreSet.add("locale");
        this.ignoreSet.add("point");
        this.ignoreSet.add("vehicle");
        this.ignoreSet.add("points_encoded");
        this.ignoreSet.add("pointsencoded");
        this.ignoreSet.add("type");
    }

    public GraphHopperWeb setDownloader(OkHttpClient downloader) {
        this.downloader = downloader;
        return this;
    }

    public OkHttpClient getDownloader() {
        return this.downloader;
    }

    public boolean load(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return true;
    }

    public GraphHopperWeb setKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalStateException("Key cannot be empty");
        }
        this.key = key;
        return this;
    }

    public GraphHopperWeb setCalcPoints(boolean calcPoints) {
        this.calcPoints = calcPoints;
        return this;
    }

    public GraphHopperWeb setInstructions(boolean b) {
        this.instructions = b;
        return this;
    }

    public GraphHopperWeb setElevation(boolean withElevation) {
        this.elevation = withElevation;
        return this;
    }

    public GraphHopperWeb setOptimize(String optimize) {
        this.optimize = optimize;
        return this;
    }

    public GHResponse route(GHRequest ghRequest) {
        String str = "Creating request failed";
        try {
            Request okRequest = this.createRequest(ghRequest);
            str = this.getClientForRequest(ghRequest).newCall(okRequest).execute().body().string();
            JSONObject json = new JSONObject(str);
            GHResponse res = new GHResponse();
            res.addErrors(GraphHopperWeb.readErrors(json));
            if (res.hasErrors()) {
                return res;
            }
            JSONArray paths = json.getJSONArray("paths");
            boolean tmpInstructions = ghRequest.getHints().getBool("instructions", this.instructions);
            boolean tmpCalcPoints = ghRequest.getHints().getBool("calc_points", this.calcPoints);
            boolean tmpElevation = ghRequest.getHints().getBool("elevation", this.elevation);
            boolean tmpTurnDescription = ghRequest.getHints().getBool("turn_description", this.turnDescription);
            for (int index = 0; index < paths.length(); ++index) {
                JSONObject path = paths.getJSONObject(index);
                PathWrapper altRsp = GraphHopperWeb.createAltResponse(path, tmpCalcPoints, tmpInstructions, tmpElevation, tmpTurnDescription);
                res.add(altRsp);
            }
            return res;
        }
        catch (Exception ex) {
            throw new RuntimeException("Problem while fetching path " + ghRequest.getPoints() + ", error: " + ex.getMessage() + " response: " + str, ex);
        }
    }

    public String export(GHRequest ghRequest) {
        String str = "Creating request failed";
        try {
            Request okRequest = this.createRequest(ghRequest);
            str = this.getClientForRequest(ghRequest).newCall(okRequest).execute().body().string();
            return str;
        }
        catch (Exception ex) {
            throw new RuntimeException("Problem while fetching export " + ghRequest.getPoints() + ", error: " + ex.getMessage() + " response: " + str, ex);
        }
    }

    public Request createRequest(GHRequest request) {
        boolean tmpInstructions = request.getHints().getBool("instructions", this.instructions);
        boolean tmpCalcPoints = request.getHints().getBool("calc_points", this.calcPoints);
        String tmpOptimize = request.getHints().get("optimize", this.optimize);
        if (tmpInstructions && !tmpCalcPoints) {
            throw new IllegalStateException("Cannot calculate instructions without points (only points without instructions). Use calc_points=false and instructions=false to disable point and instruction calculation");
        }
        boolean tmpElevation = request.getHints().getBool("elevation", this.elevation);
        String places = "";
        for (GHPoint p : request.getPoints()) {
            places = places + "point=" + Helper.round6((double)p.lat) + "," + Helper.round6((double)p.lon) + "&";
        }
        String type = request.getHints().get("type", "json");
        String url = this.serviceUrl + "?" + places + "&type=" + type + "&instructions=" + tmpInstructions + "&points_encoded=true&calc_points=" + tmpCalcPoints + "&algorithm=" + request.getAlgorithm() + "&locale=" + request.getLocale().toString() + "&elevation=" + tmpElevation + "&optimize=" + tmpOptimize;
        if (!request.getVehicle().isEmpty()) {
            url = url + "&vehicle=" + request.getVehicle();
        }
        if (!this.key.isEmpty()) {
            url = url + "&key=" + WebHelper.encodeURL(this.key);
        }
        for (Map.Entry entry : request.getHints().toMap().entrySet()) {
            String urlKey = (String)entry.getKey();
            String urlValue = (String)entry.getValue();
            if (this.ignoreSet.contains(urlKey.toLowerCase()) || urlValue == null || urlValue.isEmpty()) continue;
            url = url + "&" + WebHelper.encodeURL(urlKey) + "=" + WebHelper.encodeURL(urlValue);
        }
        return new Request.Builder().url(url).build();
    }

    public static PathWrapper createAltResponse(JSONObject path, boolean tmpCalcPoints, boolean tmpInstructions, boolean tmpElevation, boolean turnDescription) {
        PathWrapper pathWrapper = new PathWrapper();
        pathWrapper.addErrors(GraphHopperWeb.readErrors(path));
        if (pathWrapper.hasErrors()) {
            return pathWrapper;
        }
        if (path.has("snapped_waypoints")) {
            String snappedPointStr = path.getString("snapped_waypoints");
            PointList snappedPoints = WebHelper.decodePolyline(snappedPointStr, 5, tmpElevation);
            pathWrapper.setWaypoints(snappedPoints);
        }
        if (tmpCalcPoints) {
            String pointStr = path.getString("points");
            PointList pointList = WebHelper.decodePolyline(pointStr, 100, tmpElevation);
            pathWrapper.setPoints(pointList);
            if (tmpInstructions) {
                JSONArray instrArr = path.getJSONArray("instructions");
                InstructionList il = new InstructionList(null);
                int viaCount = 1;
                for (int instrIndex = 0; instrIndex < instrArr.length(); ++instrIndex) {
                    Object instr;
                    JSONObject jsonObj = instrArr.getJSONObject(instrIndex);
                    double instDist = jsonObj.getDouble("distance");
                    String text = turnDescription ? jsonObj.getString("text") : jsonObj.getString("street_name");
                    long instTime = jsonObj.getLong("time");
                    int sign = jsonObj.getInt("sign");
                    JSONArray iv = jsonObj.getJSONArray("interval");
                    int from = iv.getInt(0);
                    int to = iv.getInt(1);
                    PointList instPL = new PointList(to - from, tmpElevation);
                    for (int j = from; j <= to; ++j) {
                        instPL.add((PointAccess)pointList, j);
                    }
                    InstructionAnnotation ia = InstructionAnnotation.EMPTY;
                    if (jsonObj.has("annotation_importance") && jsonObj.has("annotation_text")) {
                        ia = new InstructionAnnotation(jsonObj.getInt("annotation_importance"), jsonObj.getString("annotation_text"));
                    }
                    if (sign == 6 || sign == -6) {
                        RoundaboutInstruction ri = new RoundaboutInstruction(sign, text, ia, instPL);
                        if (jsonObj.has("exit_number")) {
                            ri.setExitNumber(jsonObj.getInt("exit_number"));
                        }
                        if (jsonObj.has("exited") && jsonObj.getBoolean("exited")) {
                            ri.setExited();
                        }
                        if (jsonObj.has("turn_angle")) {
                            double angle = jsonObj.getDouble("turn_angle");
                            ri.setDirOfRotation(angle);
                            ri.setRadian((angle < 0.0 ? -Math.PI : Math.PI) - angle);
                        }
                        instr = ri;
                    } else if (sign == 5) {
                        ViaInstruction tmpInstr = new ViaInstruction(text, ia, instPL);
                        tmpInstr.setViaCount(viaCount);
                        ++viaCount;
                        instr = tmpInstr;
                    } else {
                        instr = sign == 4 ? new FinishInstruction(text, (PointAccess)instPL, 0) : new Instruction(sign, text, ia, instPL);
                    }
                    if (turnDescription) {
                        instr.setUseRawName();
                    }
                    instr.setDistance(instDist).setTime(instTime);
                    il.add((Instruction)instr);
                }
                pathWrapper.setInstructions(il);
            }
        }
        double distance = path.getDouble("distance");
        long time = path.getLong("time");
        pathWrapper.setDistance(distance).setTime(time);
        return pathWrapper;
    }

    private static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>(object.keySet().size());
        for (String key : object.keySet()) {
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = GraphHopperWeb.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = GraphHopperWeb.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    private static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : array) {
            if (value instanceof JSONArray) {
                value = GraphHopperWeb.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = GraphHopperWeb.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    private OkHttpClient getClientForRequest(GHRequest request) {
        OkHttpClient client = this.downloader;
        if (request.getHints().has(TIMEOUT)) {
            long timeout = request.getHints().getLong(TIMEOUT, 5000L);
            client = client.newBuilder().connectTimeout(timeout, TimeUnit.MILLISECONDS).readTimeout(timeout, TimeUnit.MILLISECONDS).build();
        }
        return client;
    }

    public static List<Throwable> readErrors(JSONObject json) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        if (json.has("message")) {
            if (!json.has("hints")) {
                errors.add(new RuntimeException(json.getString("message")));
                return errors;
            }
        } else {
            return errors;
        }
        JSONArray errorJson = json.getJSONArray("hints");
        for (int i = 0; i < errorJson.length(); ++i) {
            int pointIndex;
            JSONObject error = errorJson.getJSONObject(i);
            String exClass = "";
            if (error.has("details")) {
                exClass = error.getString("details");
            }
            String exMessage = error.getString("message");
            if (exClass.equals(UnsupportedOperationException.class.getName())) {
                errors.add(new UnsupportedOperationException(exMessage));
                continue;
            }
            if (exClass.equals(IllegalStateException.class.getName())) {
                errors.add(new IllegalStateException(exMessage));
                continue;
            }
            if (exClass.equals(RuntimeException.class.getName())) {
                errors.add((Throwable)new DetailedRuntimeException(exMessage, GraphHopperWeb.toMap(error)));
                continue;
            }
            if (exClass.equals(IllegalArgumentException.class.getName())) {
                errors.add((Throwable)new DetailedIllegalArgumentException(exMessage, GraphHopperWeb.toMap(error)));
                continue;
            }
            if (exClass.equals(ConnectionNotFoundException.class.getName())) {
                errors.add((Throwable)new ConnectionNotFoundException(exMessage, GraphHopperWeb.toMap(error)));
                continue;
            }
            if (exClass.equals(PointNotFoundException.class.getName())) {
                pointIndex = error.getInt("point_index");
                errors.add((Throwable)new PointNotFoundException(exMessage, pointIndex));
                continue;
            }
            if (exClass.equals(PointOutOfBoundsException.class.getName())) {
                pointIndex = error.getInt("point_index");
                errors.add((Throwable)new PointOutOfBoundsException(exMessage, pointIndex));
                continue;
            }
            if (exClass.isEmpty()) {
                errors.add((Throwable)new DetailedRuntimeException(exMessage, GraphHopperWeb.toMap(error)));
                continue;
            }
            errors.add((Throwable)new DetailedRuntimeException(exClass + " " + exMessage, GraphHopperWeb.toMap(error)));
        }
        if (json.has("message") && errors.isEmpty()) {
            errors.add(new RuntimeException(json.getString("message")));
        }
        return errors;
    }
}

